const marquee = document.getElementById("slider");
const imgBox = document.getElementById("imgBox");

// Function to duplicate images once
function duplicateImages() {
  const allImgs = imgBox.querySelectorAll("img");
  allImgs.forEach((img) => {
    const clone = img.cloneNode(true);
    imgBox.appendChild(clone);
  });
}

// Reset duplicates to prevent DOM overload
function resetImages() {
  const originalImages = Array.from(imgBox.querySelectorAll("img")).slice(0, 4); // first 4 are originals
  imgBox.innerHTML = "";
  originalImages.forEach((img) => imgBox.appendChild(img));
  duplicateImages(); // duplicate again for smooth loop
  setupHoverPause(); // reapply hover listeners
}

duplicateImages(); // initial duplication

// Duplicate every 4 seconds
const duplicationInterval = setInterval(duplicateImages, 4000);

// Reset every 30 seconds to prevent lag
setInterval(resetImages, 30000);

// Hover pause
function setupHoverPause() {
  const images = document.querySelectorAll(".img");
  images.forEach((img) => {
    img.addEventListener("mouseover", () => marquee.stop());
    img.addEventListener("mouseout", () => marquee.start());
  });
}

setupHoverPause();

// Mutation observer to reapply hover pause for new images
const observer = new MutationObserver(setupHoverPause);
observer.observe(imgBox, { childList: true });
